/*
 * Decompiled with CFR 0.152.
 */
package technology.rocketjump.undermount.entities.model.physical;

import com.badlogic.gdx.ai.msg.MessageDispatcher;
import java.util.HashMap;
import java.util.Map;
import technology.rocketjump.undermount.assets.entities.model.EntityAsset;
import technology.rocketjump.undermount.assets.entities.model.EntityAssetType;
import technology.rocketjump.undermount.entities.components.EntityComponent;
import technology.rocketjump.undermount.entities.model.physical.EntityAttributes;
import technology.rocketjump.undermount.mapping.model.TiledMap;

public class PhysicalEntityComponent
implements EntityComponent {
    private EntityAttributes attributes;
    private EntityAsset baseAsset;
    private final Map<EntityAssetType, EntityAsset> typeMap = new HashMap<EntityAssetType, EntityAsset>();
    private float animationProgress;

    @Override
    public PhysicalEntityComponent clone(MessageDispatcher messageDispatcher, TiledMap tiledMap) {
        PhysicalEntityComponent cloned = new PhysicalEntityComponent();
        cloned.attributes = this.attributes.clone();
        cloned.baseAsset = this.baseAsset;
        for (Map.Entry<EntityAssetType, EntityAsset> entry : this.typeMap.entrySet()) {
            cloned.typeMap.put(entry.getKey(), entry.getValue());
        }
        return cloned;
    }

    public Map<EntityAssetType, EntityAsset> getTypeMap() {
        return this.typeMap;
    }

    public EntityAsset getBaseAsset() {
        return this.baseAsset;
    }

    public void setBaseAsset(EntityAsset baseAsset) {
        this.baseAsset = baseAsset;
    }

    public EntityAttributes getAttributes() {
        return this.attributes;
    }

    public void setAttributes(EntityAttributes attributes) {
        this.attributes = attributes;
    }

    public float getAnimationProgress() {
        return this.animationProgress;
    }

    public void setAnimationProgress(float animationProgress) {
        this.animationProgress = animationProgress;
    }
}

